﻿/*	1.0
	
	WHAT: 
	This locates an item in a tree.
	Specifically,  it uses a label to locate an XML node within a tree or tree-node.
	It returns either a reference to the XML node it found,  or it returns undefined.
	X		Optionally,  it can also open all parent nodes leading to the found node.
*/

// This function does not use  "function funcName("  because "this" would be undefined if it did.
var findNode_selfTree = this;
var findNode = function( labelName, self_tree, parentNode ){
	if( typeof(labelName) !== "string" )									return undefined;
	
	// try to acquire a tree to work with
	if( self_tree instanceof mx.controls.Tree === false )					var self_tree = findNode_selfTree;
	if( self_tree instanceof mx.controls.Tree === false )					var self_tree = _this;
	if( self_tree instanceof mx.controls.Tree === false )					return undefined;
	if (self_tree.__dataProvider.length == 0)		// if:  the list is empty
		return undefined;
	
	if( !parentNode )																			var parentNode = self_tree.dataProvider;
	
	var labelName = labelName.toLowerCase();
	
	var output = undefined;
	for( var i=0; i<parentNode.childNodes.length; i++ ){
		var thisNode = parentNode.childNodes[i];
		if( thisNode.attributes.label.toLowerCase() === labelName )		return thisNode;
		// recursively search inside of this node
		if( thisNode.childNodes.length > 0 )		output = findNode( labelName, self_tree, thisNode );
		if( output !== undefined )		return output;
	}// for:  each node in this tree / parentNode
	
	// Requested node was not found within this particular tree
	return undefined;
}// findNode()